/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.builder;

import com.aptana.core.resources.FileStoreUniformResource;
import com.aptana.core.resources.IUniformResource;
import com.aptana.editor.php.internal.builder.AbstractBuildPathResource;
import com.aptana.editor.php.internal.core.builder.IBuildPath;
import com.aptana.editor.php.internal.core.builder.IModule;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.eclipse.core.filesystem.EFS;

public class FileSystemModule
extends AbstractBuildPathResource
implements IModule {
    private File file;
    private IUniformResource uniformResource;
    private boolean isInWorkspace;

    public FileSystemModule(File file, IBuildPath buildPath, boolean isInWorkspace) {
        super(buildPath, file.getAbsolutePath());
        this.file = file;
        this.isInWorkspace = isInWorkspace;
    }

    public InputStream getContents() throws FileNotFoundException {
        return new FileInputStream(this.file);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileSystemModule other = (FileSystemModule)obj;
        return !(this.file == null ? other.file != null : !this.file.equals(other.file));
    }

    public String getShortName() {
        return this.file.getName();
    }

    protected File getFile() {
        return this.file;
    }

    @Override
    public String toString() {
        return this.file.toString();
    }

    public long getTimeStamp() {
        return this.file.lastModified();
    }

    public IUniformResource getExternalFile() {
        if (this.uniformResource == null) {
            this.uniformResource = new FileStoreUniformResource(EFS.getLocalFileSystem().fromLocalFile(this.file));
        }
        return this.uniformResource;
    }

    public boolean isInWorkspace() {
        return this.isInWorkspace;
    }
}

